var NAVTREE =
[
  [ "CMSIS-DSP", "index.html", [
    [ "CMSIS DSP Software Library", "index.html", null ],
    [ "Reference", "modules.html", [
      [ "Basic Math Functions", "group__group_math.html", [
        [ "Vector Absolute Value", "group___basic_abs.html", null ],
        [ "Vector Addition", "group___basic_add.html", null ],
        [ "Vector Dot Product", "group__dot__prod.html", null ],
        [ "Vector Multiplication", "group___basic_mult.html", null ],
        [ "Vector Negate", "group__negate.html", null ],
        [ "Vector Offset", "group__offset.html", null ],
        [ "Vector Scale", "group__scale.html", null ],
        [ "Vector Shift", "group__shift.html", null ],
        [ "Vector Subtraction", "group___basic_sub.html", null ]
      ] ],
      [ "Fast Math Functions", "group__group_fast_math.html", [
        [ "Cosine", "group__cos.html", null ],
        [ "Sine", "group__sin.html", null ],
        [ "Square Root", "group___s_q_r_t.html", null ]
      ] ],
      [ "Complex Math Functions", "group__group_cmplx_math.html", [
        [ "Complex Conjugate", "group__cmplx__conj.html", null ],
        [ "Complex Dot Product", "group__cmplx__dot__prod.html", null ],
        [ "Complex Magnitude", "group__cmplx__mag.html", null ],
        [ "Complex Magnitude Squared", "group__cmplx__mag__squared.html", null ],
        [ "Complex-by-Complex Multiplication", "group___cmplx_by_cmplx_mult.html", null ],
        [ "Complex-by-Real Multiplication", "group___cmplx_by_real_mult.html", null ]
      ] ],
      [ "Filtering Functions", "group__group_filters.html", [
        [ "High Precision Q31 Biquad Cascade Filter", "group___biquad_cascade_d_f1__32x64.html", null ],
        [ "Biquad Cascade IIR Filters Using Direct Form I Structure", "group___biquad_cascade_d_f1.html", null ],
        [ "Biquad Cascade IIR Filters Using a Direct Form II Transposed Structure", "group___biquad_cascade_d_f2_t.html", null ],
        [ "Convolution", "group___conv.html", null ],
        [ "Partial Convolution", "group___partial_conv.html", null ],
        [ "Correlation", "group___corr.html", null ],
        [ "Finite Impulse Response (FIR) Decimator", "group___f_i_r__decimate.html", null ],
        [ "Finite Impulse Response (FIR) Filters", "group___f_i_r.html", null ],
        [ "Finite Impulse Response (FIR) Lattice Filters", "group___f_i_r___lattice.html", null ],
        [ "Finite Impulse Response (FIR) Sparse Filters", "group___f_i_r___sparse.html", null ],
        [ "Infinite Impulse Response (IIR) Lattice Filters", "group___i_i_r___lattice.html", null ],
        [ "Least Mean Square (LMS) Filters", "group___l_m_s.html", null ],
        [ "Normalized LMS Filters", "group___l_m_s___n_o_r_m.html", null ],
        [ "Finite Impulse Response (FIR) Interpolator", "group___f_i_r___interpolate.html", null ]
      ] ],
      [ "Matrix Functions", "group__group_matrix.html", [
        [ "Matrix Addition", "group___matrix_add.html", null ],
        [ "Matrix Initialization", "group___matrix_init.html", null ],
        [ "Matrix Inverse", "group___matrix_inv.html", null ],
        [ "Matrix Multiplication", "group___matrix_mult.html", null ],
        [ "Matrix Scale", "group___matrix_scale.html", null ],
        [ "Matrix Subtraction", "group___matrix_sub.html", null ],
        [ "Matrix Transpose", "group___matrix_trans.html", null ]
      ] ],
      [ "Transform Functions", "group__group_transforms.html", [
        [ "Complex FFT Functions", "group___c_f_f_t___c_i_f_f_t.html", null ],
        [ "DCT Type IV Functions", "group___d_c_t4___i_d_c_t4.html", null ],
        [ "Real FFT Functions", "group___r_f_f_t___r_i_f_f_t.html", null ]
      ] ],
      [ "Controller Functions", "group__group_controller.html", [
        [ "Sine Cosine", "group___sin_cos.html", null ],
        [ "PID Motor Control", "group___p_i_d.html", null ],
        [ "Vector Clarke Transform", "group__clarke.html", null ],
        [ "Vector Inverse Clarke Transform", "group__inv__clarke.html", null ],
        [ "Vector Park Transform", "group__park.html", null ],
        [ "Vector Inverse Park transform", "group__inv__park.html", null ]
      ] ],
      [ "Statistics Functions", "group__group_stats.html", [
        [ "Maximum", "group___max.html", null ],
        [ "Mean", "group__mean.html", null ],
        [ "Minimum", "group___min.html", null ],
        [ "Power", "group__power.html", null ],
        [ "Root mean square (RMS)", "group___r_m_s.html", null ],
        [ "Standard deviation", "group___s_t_d.html", null ],
        [ "Variance", "group__variance.html", null ]
      ] ],
      [ "Support Functions", "group__group_support.html", [
        [ "Vector Copy", "group__copy.html", null ],
        [ "Vector Fill", "group___fill.html", null ],
        [ "Convert 32-bit floating point value", "group__float__to__x.html", null ],
        [ "Convert 16-bit Integer value", "group__q15__to__x.html", null ],
        [ "Convert 32-bit Integer value", "group__q31__to__x.html", null ],
        [ "Convert 8-bit Integer value", "group__q7__to__x.html", null ]
      ] ],
      [ "Interpolation Functions", "group__group_interpolation.html", [
        [ "Linear Interpolation", "group___linear_interpolate.html", null ],
        [ "Bilinear Interpolation", "group___bilinear_interpolate.html", null ]
      ] ],
      [ "Examples", "group__group_examples.html", [
        [ "Class Marks Example", "group___class_marks.html", null ],
        [ "Convolution Example", "group___convolution_example.html", null ],
        [ "Dot Product Example", "group___dotproduct_example.html", null ],
        [ "Frequency Bin Example", "group___frequency_bin.html", null ],
        [ "FIR Lowpass Filter Example", "group___f_i_r_l_p_f.html", null ],
        [ "Graphic Audio Equalizer Example", "group___g_e_q5_band.html", null ],
        [ "Linear Interpolate Example", "group___linear_interp_example.html", null ],
        [ "Matrix Example", "group___matrix_example.html", null ],
        [ "Signal Convergence Example", "group___signal_convergence.html", null ],
        [ "SineCosine Example", "group___sin_cos_example.html", null ],
        [ "Variance Example", "group___variance_example.html", null ]
      ] ]
    ] ],
    [ "Data Structures", "annotated.html", [
      [ "arm_bilinear_interp_instance_f32", "structarm__bilinear__interp__instance__f32.html", null ],
      [ "arm_bilinear_interp_instance_q15", "structarm__bilinear__interp__instance__q15.html", null ],
      [ "arm_bilinear_interp_instance_q31", "structarm__bilinear__interp__instance__q31.html", null ],
      [ "arm_bilinear_interp_instance_q7", "structarm__bilinear__interp__instance__q7.html", null ],
      [ "arm_biquad_cas_df1_32x64_ins_q31", "structarm__biquad__cas__df1__32x64__ins__q31.html", null ],
      [ "arm_biquad_cascade_df2T_instance_f32", "structarm__biquad__cascade__df2_t__instance__f32.html", null ],
      [ "arm_biquad_casd_df1_inst_f32", "structarm__biquad__casd__df1__inst__f32.html", null ],
      [ "arm_biquad_casd_df1_inst_q15", "structarm__biquad__casd__df1__inst__q15.html", null ],
      [ "arm_biquad_casd_df1_inst_q31", "structarm__biquad__casd__df1__inst__q31.html", null ],
      [ "arm_cfft_radix4_instance_f32", "structarm__cfft__radix4__instance__f32.html", null ],
      [ "arm_cfft_radix4_instance_q15", "structarm__cfft__radix4__instance__q15.html", null ],
      [ "arm_cfft_radix4_instance_q31", "structarm__cfft__radix4__instance__q31.html", null ],
      [ "arm_dct4_instance_f32", "structarm__dct4__instance__f32.html", null ],
      [ "arm_dct4_instance_q15", "structarm__dct4__instance__q15.html", null ],
      [ "arm_dct4_instance_q31", "structarm__dct4__instance__q31.html", null ],
      [ "arm_fir_decimate_instance_f32", "structarm__fir__decimate__instance__f32.html", null ],
      [ "arm_fir_decimate_instance_q15", "structarm__fir__decimate__instance__q15.html", null ],
      [ "arm_fir_decimate_instance_q31", "structarm__fir__decimate__instance__q31.html", null ],
      [ "arm_fir_instance_f32", "structarm__fir__instance__f32.html", null ],
      [ "arm_fir_instance_q15", "structarm__fir__instance__q15.html", null ],
      [ "arm_fir_instance_q31", "structarm__fir__instance__q31.html", null ],
      [ "arm_fir_instance_q7", "structarm__fir__instance__q7.html", null ],
      [ "arm_fir_interpolate_instance_f32", "structarm__fir__interpolate__instance__f32.html", null ],
      [ "arm_fir_interpolate_instance_q15", "structarm__fir__interpolate__instance__q15.html", null ],
      [ "arm_fir_interpolate_instance_q31", "structarm__fir__interpolate__instance__q31.html", null ],
      [ "arm_fir_lattice_instance_f32", "structarm__fir__lattice__instance__f32.html", null ],
      [ "arm_fir_lattice_instance_q15", "structarm__fir__lattice__instance__q15.html", null ],
      [ "arm_fir_lattice_instance_q31", "structarm__fir__lattice__instance__q31.html", null ],
      [ "arm_fir_sparse_instance_f32", "structarm__fir__sparse__instance__f32.html", null ],
      [ "arm_fir_sparse_instance_q15", "structarm__fir__sparse__instance__q15.html", null ],
      [ "arm_fir_sparse_instance_q31", "structarm__fir__sparse__instance__q31.html", null ],
      [ "arm_fir_sparse_instance_q7", "structarm__fir__sparse__instance__q7.html", null ],
      [ "arm_iir_lattice_instance_f32", "structarm__iir__lattice__instance__f32.html", null ],
      [ "arm_iir_lattice_instance_q15", "structarm__iir__lattice__instance__q15.html", null ],
      [ "arm_iir_lattice_instance_q31", "structarm__iir__lattice__instance__q31.html", null ],
      [ "arm_linear_interp_instance_f32", "structarm__linear__interp__instance__f32.html", null ],
      [ "arm_lms_instance_f32", "structarm__lms__instance__f32.html", null ],
      [ "arm_lms_instance_q15", "structarm__lms__instance__q15.html", null ],
      [ "arm_lms_instance_q31", "structarm__lms__instance__q31.html", null ],
      [ "arm_lms_norm_instance_f32", "structarm__lms__norm__instance__f32.html", null ],
      [ "arm_lms_norm_instance_q15", "structarm__lms__norm__instance__q15.html", null ],
      [ "arm_lms_norm_instance_q31", "structarm__lms__norm__instance__q31.html", null ],
      [ "arm_matrix_instance_f32", "structarm__matrix__instance__f32.html", null ],
      [ "arm_matrix_instance_q15", "structarm__matrix__instance__q15.html", null ],
      [ "arm_matrix_instance_q31", "structarm__matrix__instance__q31.html", null ],
      [ "arm_pid_instance_f32", "structarm__pid__instance__f32.html", null ],
      [ "arm_pid_instance_q15", "structarm__pid__instance__q15.html", null ],
      [ "arm_pid_instance_q31", "structarm__pid__instance__q31.html", null ],
      [ "arm_rfft_instance_f32", "structarm__rfft__instance__f32.html", null ],
      [ "arm_rfft_instance_q15", "structarm__rfft__instance__q15.html", null ],
      [ "arm_rfft_instance_q31", "structarm__rfft__instance__q31.html", null ]
    ] ],
    [ "Data Structure Index", "classes.html", null ],
    [ "Data Fields", "functions.html", null ],
    [ "Examples", "examples.html", [
      [ "arm_class_marks_example_f32.c", "arm_class_marks_example_f32_8c-example.html", null ],
      [ "arm_convolution_example_f32.c", "arm_convolution_example_f32_8c-example.html", null ],
      [ "arm_dotproduct_example_f32.c", "arm_dotproduct_example_f32_8c-example.html", null ],
      [ "arm_fft_bin_example_f32.c", "arm_fft_bin_example_f32_8c-example.html", null ],
      [ "arm_fir_example_f32.c", "arm_fir_example_f32_8c-example.html", null ],
      [ "arm_graphic_equalizer_example_q31.c", "arm_graphic_equalizer_example_q31_8c-example.html", null ],
      [ "arm_linear_interp_example_f32.c", "arm_linear_interp_example_f32_8c-example.html", null ],
      [ "arm_matrix_example_f32.c", "arm_matrix_example_f32_8c-example.html", null ],
      [ "arm_signal_converge_example_f32.c", "arm_signal_converge_example_f32_8c-example.html", null ],
      [ "arm_sin_cos_example_f32.c", "arm_sin_cos_example_f32_8c-example.html", null ],
      [ "arm_variance_example_f32.c", "arm_variance_example_f32_8c-example.html", null ]
    ] ]
  ] ]
];

function createIndent(o,domNode,node,level)
{
  if (node.parentNode && node.parentNode.parentNode)
  {
    createIndent(o,domNode,node.parentNode,level+1);
  }
  var imgNode = document.createElement("img");
  if (level==0 && node.childrenData)
  {
    node.plus_img = imgNode;
    node.expandToggle = document.createElement("a");
    node.expandToggle.href = "javascript:void(0)";
    node.expandToggle.onclick = function() 
    {
      if (node.expanded) 
      {
        $(node.getChildrenUL()).slideUp("fast");
        if (node.isLast)
        {
          node.plus_img.src = node.relpath+"ftv2plastnode.png";
        }
        else
        {
          node.plus_img.src = node.relpath+"ftv2pnode.png";
        }
        node.expanded = false;
      } 
      else 
      {
        expandNode(o, node, false);
      }
    }
    node.expandToggle.appendChild(imgNode);
    domNode.appendChild(node.expandToggle);
  }
  else
  {
    domNode.appendChild(imgNode);
  }
  if (level==0)
  {
    if (node.isLast)
    {
      if (node.childrenData)
      {
        imgNode.src = node.relpath+"ftv2plastnode.png";
      }
      else
      {
        imgNode.src = node.relpath+"ftv2lastnode.png";
        domNode.appendChild(imgNode);
      }
    }
    else
    {
      if (node.childrenData)
      {
        imgNode.src = node.relpath+"ftv2pnode.png";
      }
      else
      {
        imgNode.src = node.relpath+"ftv2node.png";
        domNode.appendChild(imgNode);
      }
    }
  }
  else
  {
    if (node.isLast)
    {
      imgNode.src = node.relpath+"ftv2blank.png";
    }
    else
    {
      imgNode.src = node.relpath+"ftv2vertline.png";
    }
  }
  imgNode.border = "0";
}

function newNode(o, po, text, link, childrenData, lastNode)
{
  var node = new Object();
  node.children = Array();
  node.childrenData = childrenData;
  node.depth = po.depth + 1;
  node.relpath = po.relpath;
  node.isLast = lastNode;

  node.li = document.createElement("li");
  po.getChildrenUL().appendChild(node.li);
  node.parentNode = po;

  node.itemDiv = document.createElement("div");
  node.itemDiv.className = "item";

  node.labelSpan = document.createElement("span");
  node.labelSpan.className = "label";

  createIndent(o,node.itemDiv,node,0);
  node.itemDiv.appendChild(node.labelSpan);
  node.li.appendChild(node.itemDiv);

  var a = document.createElement("a");
  node.labelSpan.appendChild(a);
  node.label = document.createTextNode(text);
  a.appendChild(node.label);
  if (link) 
  {
    a.href = node.relpath+link;
  } 
  else 
  {
    if (childrenData != null) 
    {
      a.className = "nolink";
      a.href = "javascript:void(0)";
      a.onclick = node.expandToggle.onclick;
      node.expanded = false;
    }
  }

  node.childrenUL = null;
  node.getChildrenUL = function() 
  {
    if (!node.childrenUL) 
    {
      node.childrenUL = document.createElement("ul");
      node.childrenUL.className = "children_ul";
      node.childrenUL.style.display = "none";
      node.li.appendChild(node.childrenUL);
    }
    return node.childrenUL;
  };

  return node;
}

function showRoot()
{
  var headerHeight = $("#top").height();
  var footerHeight = $("#nav-path").height();
  var windowHeight = $(window).height() - headerHeight - footerHeight;
  navtree.scrollTo('#selected',0,{offset:-windowHeight/2});
}

function expandNode(o, node, imm)
{
  if (node.childrenData && !node.expanded) 
  {
    if (!node.childrenVisited) 
    {
      getNode(o, node);
    }
    if (imm)
    {
      $(node.getChildrenUL()).show();
    } 
    else 
    {
      $(node.getChildrenUL()).slideDown("fast",showRoot);
    }
    if (node.isLast)
    {
      node.plus_img.src = node.relpath+"ftv2mlastnode.png";
    }
    else
    {
      node.plus_img.src = node.relpath+"ftv2mnode.png";
    }
    node.expanded = true;
  }
}

function getNode(o, po)
{
  po.childrenVisited = true;
  var l = po.childrenData.length-1;
  for (var i in po.childrenData) 
  {
    var nodeData = po.childrenData[i];
    po.children[i] = newNode(o, po, nodeData[0], nodeData[1], nodeData[2],
        i==l);
  }
}

function findNavTreePage(url, data)
{
  var nodes = data;
  var result = null;
  for (var i in nodes) 
  {
    var d = nodes[i];
    if (d[1] == url) 
    {
      return new Array(i);
    }
    else if (d[2] != null) // array of children
    {
      result = findNavTreePage(url, d[2]);
      if (result != null) 
      {
        return (new Array(i).concat(result));
      }
    }
  }
  return null;
}

function initNavTree(toroot,relpath)
{
  var o = new Object();
  o.toroot = toroot;
  o.node = new Object();
  o.node.li = document.getElementById("nav-tree-contents");
  o.node.childrenData = NAVTREE;
  o.node.children = new Array();
  o.node.childrenUL = document.createElement("ul");
  o.node.getChildrenUL = function() { return o.node.childrenUL; };
  o.node.li.appendChild(o.node.childrenUL);
  o.node.depth = 0;
  o.node.relpath = relpath;

  getNode(o, o.node);

  o.breadcrumbs = findNavTreePage(toroot, NAVTREE);
  if (o.breadcrumbs == null)
  {
    o.breadcrumbs = findNavTreePage("index.html",NAVTREE);
  }
  if (o.breadcrumbs != null && o.breadcrumbs.length>0)
  {
    var p = o.node;
    for (var i in o.breadcrumbs) 
    {
      var j = o.breadcrumbs[i];
      p = p.children[j];
      expandNode(o,p,true);
    }
    p.itemDiv.className = p.itemDiv.className + " selected";
    p.itemDiv.id = "selected";
    $(window).load(showRoot);
  }
}

