package com.fredericboisguerin.insa.simple;

import static javax.swing.JOptionPane.showMessageDialog;
import static javax.swing.SwingUtilities.invokeLater;

import java.awt.*;

import javax.swing.*;

public class ButtonActionTester {
    public static void main(String[] args) {
        invokeLater(ButtonActionTester::createAndShowGUI);
    }

    private static void createAndShowGUI() {
        JFrame window = new JFrame("Button action tester");

        JTextField jTextField = buildJTextField();

        JButton jButton = new JButton("Tell me what I wrote");
        jButton.addActionListener(e -> showInformationDialogIn(window, jTextField.getText()));

        Container contentPane = window.getContentPane();
        contentPane.add(jTextField, BorderLayout.CENTER);
        contentPane.add(jButton, BorderLayout.EAST);

        display(window);
    }

    private static void showInformationDialogIn(JFrame jFrame, String text) {
        showMessageDialog(jFrame, "Typed text: " + text);
    }

    private static void display(JFrame frame) {
        frame.pack();
        frame.setVisible(true);
        frame.setLocationRelativeTo(null);
    }

    private static JTextField buildJTextField() {
        JTextField jTextField = new JTextField();
        jTextField.setPreferredSize(new Dimension(300, 20));
        return jTextField;
    }
}
