package com.fredericboisguerin.insa.listdemo;

import static javax.swing.SwingUtilities.invokeLater;
import static javax.swing.WindowConstants.EXIT_ON_CLOSE;

import javax.swing.*;

import com.fredericboisguerin.insa.listdemo.view.ListDemoListener;
import com.fredericboisguerin.insa.listdemo.view.SwingListDemoView;

public class SwingListDemoViewTest {

    public static void main(String[] args) {
        invokeLater(SwingListDemoViewTest::createAndShowUI);
    }

    private static void createAndShowUI() {
        JFrame frame = new JFrame("ListDemoView");
        frame.setDefaultCloseOperation(EXIT_ON_CLOSE);

        SwingListDemoView listDemoView = new SwingListDemoView(new ListDemoTestListener());
        listDemoView.addEmployee("Slim");
        listDemoView.addEmployee("Vincent");
        listDemoView.addEmployee("Fred");

        listDemoView.setOpaque(true);
        frame.setContentPane(listDemoView);

        frame.pack();
        frame.setVisible(true);
        frame.setLocationRelativeTo(null);
    }

    private static class ListDemoTestListener implements ListDemoListener {
        @Override
        public void onEmployeeHired(String name, int selectedIndex) {
            System.out.println(name + " has been hired !");
        }

        @Override
        public void onEmployeeFired(int index) {
            System.out.println(String.format("Employee %d has been fired !", index));
        }
    }
}