package com.fredericboisguerin.insa.listdemo;

import static javax.swing.WindowConstants.EXIT_ON_CLOSE;

import javax.swing.*;

import com.fredericboisguerin.insa.listdemo.presenter.ListDemoPresenter;
import com.fredericboisguerin.insa.listdemo.view.SwingListDemoView;

public class ListDemoMain {
    public static void main(String[] args) {
        javax.swing.SwingUtilities.invokeLater(ListDemoMain::createAndShowGUI);
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("ListDemoView");
        frame.setDefaultCloseOperation(EXIT_ON_CLOSE);

        ListDemoPresenter listDemoPresenter = new ListDemoPresenter();
        SwingListDemoView listDemoView = new SwingListDemoView(listDemoPresenter);
        listDemoPresenter.setListDemoView(listDemoView);

        listDemoView.setOpaque(true);
        frame.setContentPane(listDemoView);

        frame.pack();
        frame.setVisible(true);
        frame.setLocationRelativeTo(null);
    }
}
