package com.fredericboisguerin.insa.listdemo.presenter;

import com.fredericboisguerin.insa.listdemo.model.Employees;
import com.fredericboisguerin.insa.listdemo.view.ListDemoListener;

public class ListDemoPresenter implements ListDemoListener {

    private final Employees employees = new Employees();
    private ListDemoView view;

    public void setListDemoView(ListDemoView view) {
        this.view = view;
        employees.forEach(view::addEmployee);
    }

    @Override
    public void onEmployeeHired(String name, int selectedIndex) {
        int index = selectedIndex >= 0 ? selectedIndex + 1 : employees.size();
        employees.add(index, name);
        view.addEmployee(index, name );
    }

    @Override
    public void onEmployeeFired(int index) {
        employees.remove(index);
        view.removeEmployee(index);
    }
}
