#! /usr/bin/env python3

import chipwhisperer as cw 
import time 
import sys
import numpy as np
import argparse
import struct
from workbench import WorkBench
import readline


# --------------------------------------------------------------------------------------- #
#                                Glitch Attack parameters                                 #
# --------------------------------------------------------------------------------------- #

upload_firmware = False
firmware        = "glitch_loop.hex"
ext_offset_min  = 900
ext_offset_max  = 2000
ext_offset_step = 1
repeat =   1
offset = -12
width  =   4

# --------------------------------------------------------------------------------------- #
#                                                                                         #
# --------------------------------------------------------------------------------------- #

def main():
	local_config = dict()
	
	wb = WorkBench(local_config.get('workbench', dict()), False)
	if upload_firmware:
		wb.upload_firmware(firmware)
		wb.reset()
		print("Firmware uploaded successfully")

	for ext_offset_it in range(ext_offset_min,ext_offset_max,ext_offset_step):
		wb.reset()
		wb.glitch_controller_set(repeat = repeat,offset = offset,ext_offset = ext_offset_it, width = width)
		wb.scope.arm()
		wb.write_simple_serial("g", bytearray([]))
		ret = wb.scope.capture()
		val = wb.read_simple_serial(4)
		if ret: # No response from target
			wb.reset()
		else: # Response from target
			if (val['valid']==False) : # UART Error
				pass
			else: # Communication ok
				gcnt = struct.unpack("<I", val['payload'])[0]
				expected=struct.unpack("<I", bytearray.fromhex("C4090000"))[0]
				if (gcnt == expected) : # Normal response
					pass
				else: #glitch!!!
					print("Glitch at ext_offset: " + str(ext_offset_it) + ", Target response: " + str(gcnt))

if __name__ == "__main__":
	main()


